@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property instanceId The instance ID of the virtual machine.
 * @property resourceGroupName The name of the resource group.
 * @property vmExtensionName The name of the virtual machine extension.
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class GetVirtualMachineScaleSetVMExtensionPlainArgs(
    public val expand: String? = null,
    public val instanceId: String,
    public val resourceGroupName: String,
    public val vmExtensionName: String,
    public val vmScaleSetName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMExtensionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmExtensionName(vmExtensionName.let({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineScaleSetVMExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineScaleSetVMExtensionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var instanceId: String? = null

    private var resourceGroupName: String? = null

    private var vmExtensionName: String? = null

    private var vmScaleSetName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("hbokvlvbrstwyaab")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("rympoirtspjrwnoc")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rlmooutdjjfgfibb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("dmihkuwyxoahvpgo")
    public suspend fun vmExtensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmExtensionName = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("vnakodxowrmpdcuh")
    public suspend fun vmScaleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmScaleSetName = mapped
    }

    internal fun build(): GetVirtualMachineScaleSetVMExtensionPlainArgs =
        GetVirtualMachineScaleSetVMExtensionPlainArgs(
            expand = expand,
            instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmExtensionName = vmExtensionName ?: throw PulumiNullFieldException("vmExtensionName"),
            vmScaleSetName = vmScaleSetName ?: throw PulumiNullFieldException("vmScaleSetName"),
        )
}
