@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'InstanceView' will retrieve the instance view of the virtual machine. 'UserData' will retrieve the UserData of the virtual machine.
 * @property instanceId The instance ID of the virtual machine.
 * @property resourceGroupName The name of the resource group.
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class GetVirtualMachineScaleSetVMPlainArgs(
    public val expand: String? = null,
    public val instanceId: String,
    public val resourceGroupName: String,
    public val vmScaleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetVMPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineScaleSetVMPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineScaleSetVMPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var instanceId: String? = null

    private var resourceGroupName: String? = null

    private var vmScaleSetName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' will retrieve the instance view of the virtual machine. 'UserData' will retrieve the UserData of the virtual machine.
     */
    @JvmName("eenimluewsxfjdya")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("dmtpmkddycqffboh")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ueocaegjbbvswtcv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("xkyvtncdkkptuekf")
    public suspend fun vmScaleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmScaleSetName = mapped
    }

    internal fun build(): GetVirtualMachineScaleSetVMPlainArgs = GetVirtualMachineScaleSetVMPlainArgs(
        expand = expand,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmScaleSetName = vmScaleSetName ?: throw PulumiNullFieldException("vmScaleSetName"),
    )
}
