@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.KeyVaultAndSecretReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Key Vault Secret Url and vault id of the encryption key
 * @property secretUrl Url pointing to a key or secret in KeyVault
 * @property sourceVault Resource id of the KeyVault containing the key or secret
 */
public data class KeyVaultAndSecretReferenceArgs(
    public val secretUrl: Output<String>,
    public val sourceVault: Output<SourceVaultArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.KeyVaultAndSecretReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.KeyVaultAndSecretReferenceArgs =
        com.pulumi.azurenative.compute.inputs.KeyVaultAndSecretReferenceArgs.builder()
            .secretUrl(secretUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultAndSecretReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultAndSecretReferenceArgsBuilder internal constructor() {
    private var secretUrl: Output<String>? = null

    private var sourceVault: Output<SourceVaultArgs>? = null

    /**
     * @param value Url pointing to a key or secret in KeyVault
     */
    @JvmName("jvphjrboamrtenxg")
    public suspend fun secretUrl(`value`: Output<String>) {
        this.secretUrl = value
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret
     */
    @JvmName("ylnpaktxwcgvvkvp")
    public suspend fun sourceVault(`value`: Output<SourceVaultArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value Url pointing to a key or secret in KeyVault
     */
    @JvmName("mcvwkvolfrgghpyh")
    public suspend fun secretUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretUrl = mapped
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret
     */
    @JvmName("dfpdgwukgdcpwiyv")
    public suspend fun sourceVault(`value`: SourceVaultArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument Resource id of the KeyVault containing the key or secret
     */
    @JvmName("wttcmbetxpchbndt")
    public suspend fun sourceVault(argument: suspend SourceVaultArgsBuilder.() -> Unit) {
        val toBeMapped = SourceVaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyVaultAndSecretReferenceArgs = KeyVaultAndSecretReferenceArgs(
        secretUrl = secretUrl ?: throw PulumiNullFieldException("secretUrl"),
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
    )
}
