@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the load balancer configuration.
 * @property id Resource Id
 * @property name The name of the Load balancer
 * @property properties Properties of the load balancer configuration.
 */
public data class LoadBalancerConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>,
    public val properties: Output<LoadBalancerConfigurationPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LoadBalancerConfigurationArgs].
 */
@PulumiTagMarker
public class LoadBalancerConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<LoadBalancerConfigurationPropertiesArgs>? = null

    /**
     * @param value Resource Id
     */
    @JvmName("ydcxnuoghemrvcdk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the Load balancer
     */
    @JvmName("fpqgisbcexukyhbm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the load balancer configuration.
     */
    @JvmName("xilgautwmqmhsydb")
    public suspend fun properties(`value`: Output<LoadBalancerConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("uupfjmpatffkkmld")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the Load balancer
     */
    @JvmName("akxvpnfkjxgqppgm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the load balancer configuration.
     */
    @JvmName("wwcwhxclpgcyxwux")
    public suspend fun properties(`value`: LoadBalancerConfigurationPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the load balancer configuration.
     */
    @JvmName("ftchhlgijyyscbab")
    public suspend
    fun properties(argument: suspend LoadBalancerConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerConfigurationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): LoadBalancerConfigurationArgs = LoadBalancerConfigurationArgs(
        id = id,
        name = name ?: throw PulumiNullFieldException("name"),
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
