@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointSourceVMStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the storage profile.
 * @property dataDisks Gets the data disks of the VM captured at the time of the restore point creation.
 * @property osDisk Gets the OS disk of the VM captured at the time of the restore point creation.
 */
public data class RestorePointSourceVMStorageProfileArgs(
    public val dataDisks: Output<List<RestorePointSourceVMDataDiskArgs>>? = null,
    public val osDisk: Output<RestorePointSourceVMOSDiskArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointSourceVMStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.RestorePointSourceVMStorageProfileArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointSourceVMStorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RestorePointSourceVMStorageProfileArgs].
 */
@PulumiTagMarker
public class RestorePointSourceVMStorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<RestorePointSourceVMDataDiskArgs>>? = null

    private var osDisk: Output<RestorePointSourceVMOSDiskArgs>? = null

    /**
     * @param value Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("oymtdogdgtwjoldq")
    public suspend fun dataDisks(`value`: Output<List<RestorePointSourceVMDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("pbbphybomywbpqaw")
    public suspend fun dataDisks(vararg values: Output<RestorePointSourceVMDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("cpubkdgsssxjtuyg")
    public suspend fun dataDisks(values: List<Output<RestorePointSourceVMDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Gets the OS disk of the VM captured at the time of the restore point creation.
     */
    @JvmName("xnkmakaepkwpdcpt")
    public suspend fun osDisk(`value`: Output<RestorePointSourceVMOSDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("dxnuaesktaduibtn")
    public suspend fun dataDisks(`value`: List<RestorePointSourceVMDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("ecvbcabjxgtdyayv")
    public suspend
    fun dataDisks(argument: List<suspend RestorePointSourceVMDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RestorePointSourceVMDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("rverxlhxlbtgohtj")
    public suspend fun dataDisks(
        vararg
        argument: suspend RestorePointSourceVMDataDiskArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RestorePointSourceVMDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("cuidjthhgljxvjsa")
    public suspend
    fun dataDisks(argument: suspend RestorePointSourceVMDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RestorePointSourceVMDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Gets the data disks of the VM captured at the time of the restore point creation.
     */
    @JvmName("dibmfeoepkvqskrh")
    public suspend fun dataDisks(vararg values: RestorePointSourceVMDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Gets the OS disk of the VM captured at the time of the restore point creation.
     */
    @JvmName("tqgpncnjpurxtwsa")
    public suspend fun osDisk(`value`: RestorePointSourceVMOSDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Gets the OS disk of the VM captured at the time of the restore point creation.
     */
    @JvmName("auryduejbogrmixg")
    public suspend fun osDisk(argument: suspend RestorePointSourceVMOSDiskArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePointSourceVMOSDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    internal fun build(): RestorePointSourceVMStorageProfileArgs =
        RestorePointSourceVMStorageProfileArgs(
            dataDisks = dataDisks,
            osDisk = osDisk,
        )
}
