@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SoftDeletePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about the soft deletion policy of the gallery.
 * @property isSoftDeleteEnabled Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
 */
public data class SoftDeletePolicyArgs(
    public val isSoftDeleteEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SoftDeletePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SoftDeletePolicyArgs =
        com.pulumi.azurenative.compute.inputs.SoftDeletePolicyArgs.builder()
            .isSoftDeleteEnabled(isSoftDeleteEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SoftDeletePolicyArgs].
 */
@PulumiTagMarker
public class SoftDeletePolicyArgsBuilder internal constructor() {
    private var isSoftDeleteEnabled: Output<Boolean>? = null

    /**
     * @param value Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
     */
    @JvmName("suierhyvvsemylnn")
    public suspend fun isSoftDeleteEnabled(`value`: Output<Boolean>) {
        this.isSoftDeleteEnabled = value
    }

    /**
     * @param value Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
     */
    @JvmName("yatrmwgjrmgvyqpt")
    public suspend fun isSoftDeleteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSoftDeleteEnabled = mapped
    }

    internal fun build(): SoftDeletePolicyArgs = SoftDeletePolicyArgs(
        isSoftDeleteEnabled = isSoftDeleteEnabled,
    )
}
