@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.UserArtifactSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The source image from which the Image Version is going to be created.
 * @property defaultConfigurationLink Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
 * @property mediaLink Required. The mediaLink of the artifact, must be a readable storage page blob.
 */
public data class UserArtifactSourceArgs(
    public val defaultConfigurationLink: Output<String>? = null,
    public val mediaLink: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.UserArtifactSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.UserArtifactSourceArgs =
        com.pulumi.azurenative.compute.inputs.UserArtifactSourceArgs.builder()
            .defaultConfigurationLink(defaultConfigurationLink?.applyValue({ args0 -> args0 }))
            .mediaLink(mediaLink.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArtifactSourceArgs].
 */
@PulumiTagMarker
public class UserArtifactSourceArgsBuilder internal constructor() {
    private var defaultConfigurationLink: Output<String>? = null

    private var mediaLink: Output<String>? = null

    /**
     * @param value Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
     */
    @JvmName("vgskqvddoeadgcyb")
    public suspend fun defaultConfigurationLink(`value`: Output<String>) {
        this.defaultConfigurationLink = value
    }

    /**
     * @param value Required. The mediaLink of the artifact, must be a readable storage page blob.
     */
    @JvmName("ijroklxafctdnmie")
    public suspend fun mediaLink(`value`: Output<String>) {
        this.mediaLink = value
    }

    /**
     * @param value Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
     */
    @JvmName("xjqvvqydgttsiaal")
    public suspend fun defaultConfigurationLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultConfigurationLink = mapped
    }

    /**
     * @param value Required. The mediaLink of the artifact, must be a readable storage page blob.
     */
    @JvmName("sitpvogldoipcshm")
    public suspend fun mediaLink(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaLink = mapped
    }

    internal fun build(): UserArtifactSourceArgs = UserArtifactSourceArgs(
        defaultConfigurationLink = defaultConfigurationLink,
        mediaLink = mediaLink ?: throw PulumiNullFieldException("mediaLink"),
    )
}
