@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.SecurityEncryptionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the security profile settings for the managed disk. **Note:** It can only be set for Confidential VMs.
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
 * @property securityEncryptionType Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
 */
public data class VMDiskSecurityProfileArgs(
    public val diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null,
    public val securityEncryptionType: Output<Either<String, SecurityEncryptionTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs =
        com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs.builder()
            .diskEncryptionSet(diskEncryptionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityEncryptionType(
                securityEncryptionType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [VMDiskSecurityProfileArgs].
 */
@PulumiTagMarker
public class VMDiskSecurityProfileArgsBuilder internal constructor() {
    private var diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null

    private var securityEncryptionType: Output<Either<String, SecurityEncryptionTypes>>? = null

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
     */
    @JvmName("gsdxrivexdgkyvev")
    public suspend fun diskEncryptionSet(`value`: Output<DiskEncryptionSetParametersArgs>) {
        this.diskEncryptionSet = value
    }

    /**
     * @param value Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
     */
    @JvmName("clnxdfffibopxnsx")
    public suspend
    fun securityEncryptionType(`value`: Output<Either<String, SecurityEncryptionTypes>>) {
        this.securityEncryptionType = value
    }

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
     */
    @JvmName("uapqawyloesfnvyt")
    public suspend fun diskEncryptionSet(`value`: DiskEncryptionSetParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSet = mapped
    }

    /**
     * @param argument Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
     */
    @JvmName("khwvatmvdhjwanvr")
    public suspend
    fun diskEncryptionSet(argument: suspend DiskEncryptionSetParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionSetParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionSet = mapped
    }

    /**
     * @param value Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
     */
    @JvmName("olsjrwfqwisdehuq")
    public suspend fun securityEncryptionType(`value`: Either<String, SecurityEncryptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityEncryptionType = mapped
    }

    /**
     * @param value Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
     */
    @JvmName("ubxfnnmytdrpduvj")
    public fun securityEncryptionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityEncryptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityEncryptionType = mapped
    }

    /**
     * @param value Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
     */
    @JvmName("yiwalkayltwsoamp")
    public fun securityEncryptionType(`value`: SecurityEncryptionTypes) {
        val toBeMapped = Either.ofRight<String, SecurityEncryptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityEncryptionType = mapped
    }

    internal fun build(): VMDiskSecurityProfileArgs = VMDiskSecurityProfileArgs(
        diskEncryptionSet = diskEncryptionSet,
        securityEncryptionType = securityEncryptionType,
    )
}
