@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine Extension.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property instanceView The virtual machine extension instance view.
 * @property location Resource location
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property tags Resource tags
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VirtualMachineExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null,
    public val location: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val suppressFailures: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineExtensionArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .instanceView(instanceView?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .suppressFailures(suppressFailures?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineExtensionArgs].
 */
@PulumiTagMarker
public class VirtualMachineExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null

    private var location: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var settings: Output<Any>? = null

    private var suppressFailures: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("iunqwmcijsyavdkp")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("mkmipqdhukgwfciq")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("ommdryghucxhksbq")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("gcndxeimxqtrgxtc")
    public suspend fun instanceView(`value`: Output<VirtualMachineExtensionInstanceViewArgs>) {
        this.instanceView = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("wtitdvapnjxjiork")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("vlkbfdnbabgvbcfn")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("edqgswcwpbdnliof")
    public suspend fun protectedSettingsFromKeyVault(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("ourciyymelhpbhgg")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("ogdfdwuluosolvtl")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("ykuymewtvtijdfie")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("wdjpxjshdjonyare")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("qgekjwmheuajbpoq")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("ykdvrbctummavbqo")
    public suspend fun suppressFailures(`value`: Output<Boolean>) {
        this.suppressFailures = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("itwcwsctkxwtdbgi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("lpyotjshsfavvmim")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("ggdauramoaajufpc")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("ubnaagwuaoglivjs")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("oabbdbaobhpfwjim")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("pfugvljlcldskgnf")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("bexigsjvncyujxbu")
    public suspend fun instanceView(`value`: VirtualMachineExtensionInstanceViewArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceView = mapped
    }

    /**
     * @param argument The virtual machine extension instance view.
     */
    @JvmName("klmudskwhjoytusf")
    public suspend
    fun instanceView(argument: suspend VirtualMachineExtensionInstanceViewArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineExtensionInstanceViewArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceView = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("eiwdokqtgebcoqjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("heansvjjiuryucoa")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("fwbyajipsxkstblt")
    public suspend fun protectedSettingsFromKeyVault(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("hpvskqmeefsydwng")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("fqxuauesgldnetym")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("arttlcsantilxpba")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("gbadantaxckikhsr")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("meatnbvihtgousnc")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("ublgrvshuinitldl")
    public suspend fun suppressFailures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressFailures = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xourgdngitexbmxe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("srwjvfkcnadkvpfs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("tystclknrvwrvgrj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("makkofqkiwylbtqw")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): VirtualMachineExtensionArgs = VirtualMachineExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        forceUpdateTag = forceUpdateTag,
        instanceView = instanceView,
        location = location,
        protectedSettings = protectedSettings,
        protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
        provisionAfterExtensions = provisionAfterExtensions,
        publisher = publisher,
        settings = settings,
        suppressFailures = suppressFailures,
        tags = tags,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
