@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressConfigurationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DeleteOptions
import com.pulumi.azurenative.compute.kotlin.enums.IPVersions
import com.pulumi.azurenative.compute.kotlin.enums.PublicIPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines IP Configuration's PublicIPAddress configuration
 * @property deleteOption Specify what happens to the public IP address when the VM is deleted
 * @property dnsSettings The dns settings to be applied on the publicIP addresses .
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipTags The list of IP tags associated with the public IP address.
 * @property name The publicIP address configuration name.
 * @property publicIPAddressVersion Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPAllocationMethod Specify the public IP allocation type
 * @property publicIPPrefix The PublicIPPrefix from which to allocate publicIP addresses.
 * @property sku Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
 */
public data class VirtualMachinePublicIPAddressConfigurationArgs(
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val dnsSettings: Output<VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val ipTags: Output<List<VirtualMachineIpTagArgs>>? = null,
    public val name: Output<String>,
    public val publicIPAddressVersion: Output<Either<String, IPVersions>>? = null,
    public val publicIPAllocationMethod: Output<Either<String, PublicIPAllocationMethod>>? = null,
    public val publicIPPrefix: Output<SubResourceArgs>? = null,
    public val sku: Output<PublicIPAddressSkuArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressConfigurationArgs.builder()
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .publicIPAddressVersion(
                publicIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAllocationMethod(
                publicIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPPrefix(publicIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachinePublicIPAddressConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachinePublicIPAddressConfigurationArgsBuilder internal constructor() {
    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var dnsSettings: Output<VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var ipTags: Output<List<VirtualMachineIpTagArgs>>? = null

    private var name: Output<String>? = null

    private var publicIPAddressVersion: Output<Either<String, IPVersions>>? = null

    private var publicIPAllocationMethod: Output<Either<String, PublicIPAllocationMethod>>? = null

    private var publicIPPrefix: Output<SubResourceArgs>? = null

    private var sku: Output<PublicIPAddressSkuArgs>? = null

    /**
     * @param value Specify what happens to the public IP address when the VM is deleted
     */
    @JvmName("ouodxuojehtnpbia")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("pymchuvjjrvkirvj")
    public suspend
    fun dnsSettings(`value`: Output<VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("atcydqktrkrcfqdd")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The list of IP tags associated with the public IP address.
     */
    @JvmName("dckljovsqqunlmrp")
    public suspend fun ipTags(`value`: Output<List<VirtualMachineIpTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("ydqwufgdexqgccwg")
    public suspend fun ipTags(vararg values: Output<VirtualMachineIpTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of IP tags associated with the public IP address.
     */
    @JvmName("mnrkmirdffgpqcfm")
    public suspend fun ipTags(values: List<Output<VirtualMachineIpTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value The publicIP address configuration name.
     */
    @JvmName("sgtdiroeebnbwjjk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("xmmkuifybmcqpewd")
    public suspend fun publicIPAddressVersion(`value`: Output<Either<String, IPVersions>>) {
        this.publicIPAddressVersion = value
    }

    /**
     * @param value Specify the public IP allocation type
     */
    @JvmName("iubeakhwocbfwibb")
    public suspend
    fun publicIPAllocationMethod(`value`: Output<Either<String, PublicIPAllocationMethod>>) {
        this.publicIPAllocationMethod = value
    }

    /**
     * @param value The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("fvjxgivasignfjgv")
    public suspend fun publicIPPrefix(`value`: Output<SubResourceArgs>) {
        this.publicIPPrefix = value
    }

    /**
     * @param value Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("ygboimfwhuvbpyfr")
    public suspend fun sku(`value`: Output<PublicIPAddressSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Specify what happens to the public IP address when the VM is deleted
     */
    @JvmName("jsaejitudyfmenla")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM is deleted
     */
    @JvmName("btcneohjplwysnyl")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM is deleted
     */
    @JvmName("waklrhmrfwipxfat")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("bvxsiffnbmcdltii")
    public suspend
    fun dnsSettings(`value`: VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The dns settings to be applied on the publicIP addresses .
     */
    @JvmName("pqggfybiqdfhwqwy")
    public suspend
    fun dnsSettings(argument: suspend VirtualMachinePublicIPAddressDnsSettingsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualMachinePublicIPAddressDnsSettingsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("rftddonnjmdbjxlp")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The list of IP tags associated with the public IP address.
     */
    @JvmName("kbcbdikinyxbopfa")
    public suspend fun ipTags(`value`: List<VirtualMachineIpTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("ncotuwynahrbefpg")
    public suspend fun ipTags(argument: List<suspend VirtualMachineIpTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineIpTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("vngpvhbnxitvheif")
    public suspend fun ipTags(vararg argument: suspend VirtualMachineIpTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachineIpTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of IP tags associated with the public IP address.
     */
    @JvmName("ldmlcosrfoskpfvy")
    public suspend fun ipTags(argument: suspend VirtualMachineIpTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualMachineIpTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of IP tags associated with the public IP address.
     */
    @JvmName("pblokdjxrdgbbelr")
    public suspend fun ipTags(vararg values: VirtualMachineIpTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value The publicIP address configuration name.
     */
    @JvmName("qstvjhjlxnakmrim")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("ostvvydaixobelpl")
    public suspend fun publicIPAddressVersion(`value`: Either<String, IPVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("uhgaphxqpfhirivu")
    public fun publicIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("xfvrhkuxjcipcewa")
    public fun publicIPAddressVersion(`value`: IPVersions) {
        val toBeMapped = Either.ofRight<String, IPVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value Specify the public IP allocation type
     */
    @JvmName("wwaqjkdsqwojqnfx")
    public suspend fun publicIPAllocationMethod(`value`: Either<String, PublicIPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value Specify the public IP allocation type
     */
    @JvmName("anogedoqwoywcndy")
    public fun publicIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value Specify the public IP allocation type
     */
    @JvmName("knrmvhravsjkxuff")
    public fun publicIPAllocationMethod(`value`: PublicIPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, PublicIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("woniyaetcpggxhpp")
    public suspend fun publicIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefix = mapped
    }

    /**
     * @param argument The PublicIPPrefix from which to allocate publicIP addresses.
     */
    @JvmName("prlcjsnqbnsinsct")
    public suspend fun publicIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPPrefix = mapped
    }

    /**
     * @param value Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("kddvsjdgqhmhynxe")
    public suspend fun sku(`value`: PublicIPAddressSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
     */
    @JvmName("wgrglslxaendahik")
    public suspend fun sku(argument: suspend PublicIPAddressSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): VirtualMachinePublicIPAddressConfigurationArgs =
        VirtualMachinePublicIPAddressConfigurationArgs(
            deleteOption = deleteOption,
            dnsSettings = dnsSettings,
            idleTimeoutInMinutes = idleTimeoutInMinutes,
            ipTags = ipTags,
            name = name ?: throw PulumiNullFieldException("name"),
            publicIPAddressVersion = publicIPAddressVersion,
            publicIPAllocationMethod = publicIPAllocationMethod,
            publicIPPrefix = publicIPPrefix,
            sku = sku,
        )
}
