@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine Scale Set Extension.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
 * @property name The name of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VirtualMachineScaleSetExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val suppressFailures: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .suppressFailures(suppressFailures?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetExtensionArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var name: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var settings: Output<Any>? = null

    private var suppressFailures: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("tykhrahqanpklsnd")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("yoddnukqxqruvcjp")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("awkviorlrahyofle")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("eiotooaljujmborw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("qdgrhwprffadahxk")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("dqxaweijkkgfqxpj")
    public suspend fun protectedSettingsFromKeyVault(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("uyvdwltunhddkenb")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("wkcsmgptssawsuqx")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("fgmrsbspjympgbjl")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("bsckeaqjltpjssvv")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("lcvxaqnylrllciwx")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("ptjqhpefaajusjcd")
    public suspend fun suppressFailures(`value`: Output<Boolean>) {
        this.suppressFailures = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("pxhsnnuyxvtjjqgs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("qjuvwucbecfefbxl")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("pijjwnoslgsljono")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("bkcoggynkrrqacvb")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("irodgsowcsssqaqa")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("fmpasfqgguijfgwq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("uctooukldwoshiyb")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("endnrmbbkfxbrfxt")
    public suspend fun protectedSettingsFromKeyVault(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("pviykbkiyxcsidoe")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("anmrgnvexgrqakri")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("rhfnoegbqotpnfts")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("lvvetmulyvhgffei")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("ojnxelrtkigyrjcf")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("ewunsqnhubxulcmk")
    public suspend fun suppressFailures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressFailures = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("ogdfpeyvdpmcanug")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("ftmetjtaigeldxro")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): VirtualMachineScaleSetExtensionArgs = VirtualMachineScaleSetExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        forceUpdateTag = forceUpdateTag,
        name = name,
        protectedSettings = protectedSettings,
        protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
        provisionAfterExtensions = provisionAfterExtensions,
        publisher = publisher,
        settings = settings,
        suppressFailures = suppressFailures,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
