@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.WinRMListenerArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ProtocolTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes Protocol and thumbprint of Windows Remote Management listener
 * @property certificateUrl This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
 * @property protocol Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**
 */
public data class WinRMListenerArgs(
    public val certificateUrl: Output<String>? = null,
    public val protocol: Output<ProtocolTypes>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.WinRMListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.WinRMListenerArgs =
        com.pulumi.azurenative.compute.inputs.WinRMListenerArgs.builder()
            .certificateUrl(certificateUrl?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WinRMListenerArgs].
 */
@PulumiTagMarker
public class WinRMListenerArgsBuilder internal constructor() {
    private var certificateUrl: Output<String>? = null

    private var protocol: Output<ProtocolTypes>? = null

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("ielxxlknwehiodws")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**
     */
    @JvmName("ihstsfgxlxlsnjdb")
    public suspend fun protocol(`value`: Output<ProtocolTypes>) {
        this.protocol = value
    }

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("apnknvyltbwklonk")
    public suspend fun certificateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    /**
     * @param value Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**
     */
    @JvmName("snnhsqgobneedycb")
    public suspend fun protocol(`value`: ProtocolTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): WinRMListenerArgs = WinRMListenerArgs(
        certificateUrl = certificateUrl,
        protocol = protocol,
    )
}
