@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Enables or disables a capability on the virtual machine or virtual machine scale set.
 * @property hibernationEnabled The flag that enables or disables hibernation capability on the VM.
 * @property ultraSSDEnabled The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.
 */
public data class AdditionalCapabilitiesResponse(
    public val hibernationEnabled: Boolean? = null,
    public val ultraSSDEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.AdditionalCapabilitiesResponse):
            AdditionalCapabilitiesResponse = AdditionalCapabilitiesResponse(
            hibernationEnabled = javaType.hibernationEnabled().map({ args0 -> args0 }).orElse(null),
            ultraSSDEnabled = javaType.ultraSSDEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
