@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Api error.
 * @property code The error code.
 * @property details The Api error details
 * @property innererror The Api inner error
 * @property message The error message.
 * @property target The target of the particular error.
 */
public data class ApiErrorResponse(
    public val code: String? = null,
    public val details: List<ApiErrorBaseResponse>? = null,
    public val innererror: InnerErrorResponse? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ApiErrorResponse):
            ApiErrorResponse = ApiErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorBaseResponse.Companion.toKotlin(args0)
                })
            }),
            innererror = javaType.innererror().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InnerErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
