@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The instance view of a virtual machine boot diagnostics.
 * @property consoleScreenshotBlobUri The console screenshot blob URI. **Note:** This will **not** be set if boot diagnostics is currently enabled with managed storage.
 * @property serialConsoleLogBlobUri The serial console log blob Uri. **Note:** This will **not** be set if boot diagnostics is currently enabled with managed storage.
 * @property status The boot diagnostics status information for the VM. **Note:** It will be set only if there are errors encountered in enabling boot diagnostics.
 */
public data class BootDiagnosticsInstanceViewResponse(
    public val consoleScreenshotBlobUri: String,
    public val serialConsoleLogBlobUri: String,
    public val status: InstanceViewStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.BootDiagnosticsInstanceViewResponse):
            BootDiagnosticsInstanceViewResponse = BootDiagnosticsInstanceViewResponse(
            consoleScreenshotBlobUri = javaType.consoleScreenshotBlobUri(),
            serialConsoleLogBlobUri = javaType.serialConsoleLogBlobUri(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
