@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents the capacity reservation utilization in terms of resources allocated.
 * @property currentCapacity The value provides the current capacity of the VM size which was reserved successfully and for which the customer is getting billed. Minimum api-version: 2022-08-01.
 * @property virtualMachinesAllocated A list of all virtual machines resource ids allocated against the capacity reservation.
 */
public data class CapacityReservationUtilizationResponse(
    public val currentCapacity: Int,
    public val virtualMachinesAllocated: List<SubResourceReadOnlyResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CapacityReservationUtilizationResponse):
            CapacityReservationUtilizationResponse = CapacityReservationUtilizationResponse(
            currentCapacity = javaType.currentCapacity(),
            virtualMachinesAllocated = javaType.virtualMachinesAllocated().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
