@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the OS profile for the cloud service.
 * @property secrets Specifies set of certificates that should be installed onto the role instances.
 */
public data class CloudServiceOsProfileResponse(
    public val secrets: List<CloudServiceVaultSecretGroupResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceOsProfileResponse):
            CloudServiceOsProfileResponse = CloudServiceOsProfileResponse(
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceVaultSecretGroupResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
