@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the role properties.
 * @property name Resource name.
 * @property sku Describes the cloud service role sku.
 */
public data class CloudServiceRoleProfilePropertiesResponse(
    public val name: String? = null,
    public val sku: CloudServiceRoleSkuResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceRoleProfilePropertiesResponse):
            CloudServiceRoleProfilePropertiesResponse = CloudServiceRoleProfilePropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceRoleSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
