@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
 * @property secretUrl Secret URL which contains the protected settings of the extension
 * @property sourceVault The ARM Resource ID of the Key Vault
 */
public data class CloudServiceVaultAndSecretReferenceResponse(
    public val secretUrl: String? = null,
    public val sourceVault: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceVaultAndSecretReferenceResponse):
            CloudServiceVaultAndSecretReferenceResponse = CloudServiceVaultAndSecretReferenceResponse(
            secretUrl = javaType.secretUrl().map({ args0 -> args0 }).orElse(null),
            sourceVault = javaType.sourceVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
