@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.
 * @property certificateUrl This is the URL of a certificate that has been uploaded to Key Vault as a secret.
 */
public data class CloudServiceVaultCertificateResponse(
    public val certificateUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceVaultCertificateResponse):
            CloudServiceVaultCertificateResponse = CloudServiceVaultCertificateResponse(
            certificateUrl = javaType.certificateUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
