@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information of community gallery if current gallery is shared to community
 * @property communityGalleryEnabled Contains info about whether community gallery sharing is enabled.
 * @property eula End-user license agreement for community gallery image.
 * @property publicNamePrefix The prefix of the gallery name that will be displayed publicly. Visible to all users.
 * @property publicNames Community gallery public name list.
 * @property publisherContact Community gallery publisher support email. The email address of the publisher. Visible to all users.
 * @property publisherUri The link to the publisher website. Visible to all users.
 */
public data class CommunityGalleryInfoResponse(
    public val communityGalleryEnabled: Boolean,
    public val eula: String? = null,
    public val publicNamePrefix: String? = null,
    public val publicNames: List<String>,
    public val publisherContact: String? = null,
    public val publisherUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CommunityGalleryInfoResponse):
            CommunityGalleryInfoResponse = CommunityGalleryInfoResponse(
            communityGalleryEnabled = javaType.communityGalleryEnabled(),
            eula = javaType.eula().map({ args0 -> args0 }).orElse(null),
            publicNamePrefix = javaType.publicNamePrefix().map({ args0 -> args0 }).orElse(null),
            publicNames = javaType.publicNames().map({ args0 -> args0 }),
            publisherContact = javaType.publisherContact().map({ args0 -> args0 }).orElse(null),
            publisherUri = javaType.publisherUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
