@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Represents the dedicated host unutilized capacity in terms of a specific VM size.
 * @property count Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
 * @property vmSize VM size in terms of which the unutilized capacity is represented.
 */
public data class DedicatedHostAllocatableVMResponse(
    public val count: Double? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DedicatedHostAllocatableVMResponse):
            DedicatedHostAllocatableVMResponse = DedicatedHostAllocatableVMResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
