@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the parameters of ephemeral disk settings that can be specified for operating system disk. **Note:** The ephemeral disk settings can only be specified for managed disk.
 * @property option Specifies the ephemeral disk settings for operating system disk.
 * @property placement Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
 */
public data class DiffDiskSettingsResponse(
    public val option: String? = null,
    public val placement: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiffDiskSettingsResponse):
            DiffDiskSettingsResponse = DiffDiskSettingsResponse(
            option = javaType.option().map({ args0 -> args0 }).orElse(null),
            placement = javaType.placement().map({ args0 -> args0 }).orElse(null),
        )
    }
}
