@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress

/**
 * Encryption settings for one disk volume.
 * @property diskEncryptionKey Key Vault Secret Url and vault id of the disk encryption key
 * @property keyEncryptionKey Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
 */
public data class EncryptionSettingsElementResponse(
    public val diskEncryptionKey: KeyVaultAndSecretReferenceResponse? = null,
    public val keyEncryptionKey: KeyVaultAndKeyReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.EncryptionSettingsElementResponse):
            EncryptionSettingsElementResponse = EncryptionSettingsElementResponse(
            diskEncryptionKey = javaType.diskEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultAndSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultAndKeyReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
