@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * This is the data disk image.
 * @property hostCaching The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
 * @property lun This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
 * @property sizeInGB This property indicates the size of the VHD to be created.
 * @property source The source for the disk image.
 */
public data class GalleryDataDiskImageResponse(
    public val hostCaching: String? = null,
    public val lun: Int,
    public val sizeInGB: Int,
    public val source: GalleryDiskImageSourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryDataDiskImageResponse):
            GalleryDataDiskImageResponse = GalleryDataDiskImageResponse(
            hostCaching = javaType.hostCaching().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun(),
            sizeInGB = javaType.sizeInGB(),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryDiskImageSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
