@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * This is the storage profile of a Gallery Image Version.
 * @property dataDiskImages A list of data disk images.
 * @property osDiskImage This is the OS disk image.
 * @property source The source of the gallery artifact version.
 */
public data class GalleryImageVersionStorageProfileResponse(
    public val dataDiskImages: List<GalleryDataDiskImageResponse>? = null,
    public val osDiskImage: GalleryOSDiskImageResponse? = null,
    public val source: GalleryArtifactVersionFullSourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryImageVersionStorageProfileResponse):
            GalleryImageVersionStorageProfileResponse = GalleryImageVersionStorageProfileResponse(
            dataDiskImages = javaType.dataDiskImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryDataDiskImageResponse.Companion.toKotlin(args0)
                })
            }),
            osDiskImage = javaType.osDiskImage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryOSDiskImageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryArtifactVersionFullSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
