@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the capacity reservation.
 * @property id Resource Id
 * @property instanceView The Capacity reservation instance view.
 * @property location Resource location
 * @property name Resource name
 * @property platformFaultDomainCount Specifies the value of fault domain count that Capacity Reservation supports for requested VM size. **Note:** The fault domain count specified for a resource (like virtual machines scale set) must be less than or equal to this value if it deploys using capacity reservation. Minimum api-version: 2022-08-01.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property provisioningTime The date time when the capacity reservation was last updated.
 * @property reservationId A unique id generated and assigned to the capacity reservation by the platform which does not change throughout the lifetime of the resource.
 * @property sku SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
 * @property tags Resource tags
 * @property timeCreated Specifies the time at which the Capacity Reservation resource was created. Minimum api-version: 2021-11-01.
 * @property type Resource type
 * @property virtualMachinesAssociated A list of all virtual machine resource ids that are associated with the capacity reservation.
 * @property zones Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
 */
public data class GetCapacityReservationResult(
    public val id: String,
    public val instanceView: CapacityReservationInstanceViewResponse,
    public val location: String,
    public val name: String,
    public val platformFaultDomainCount: Int,
    public val provisioningState: String,
    public val provisioningTime: String,
    public val reservationId: String,
    public val sku: SkuResponse,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
    public val virtualMachinesAssociated: List<SubResourceReadOnlyResponse>,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetCapacityReservationResult):
            GetCapacityReservationResult = GetCapacityReservationResult(
            id = javaType.id(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationInstanceViewResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            platformFaultDomainCount = javaType.platformFaultDomainCount(),
            provisioningState = javaType.provisioningState(),
            provisioningTime = javaType.provisioningTime(),
            reservationId = javaType.reservationId(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            virtualMachinesAssociated = javaType.virtualMachinesAssociated().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
