@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies information about the Shared Image Gallery that you want to create or update.
 * @property description The description of this Shared Image Gallery resource. This property is updatable.
 * @property id Resource Id
 * @property identifier Describes the gallery unique name.
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property sharingProfile Profile for gallery sharing to subscription or tenant
 * @property sharingStatus Sharing status of current gallery.
 * @property softDeletePolicy Contains information about the soft deletion policy of the gallery.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGalleryResult(
    public val description: String? = null,
    public val id: String,
    public val identifier: GalleryIdentifierResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sharingProfile: SharingProfileResponse? = null,
    public val sharingStatus: SharingStatusResponse,
    public val softDeletePolicy: SoftDeletePolicyResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetGalleryResult):
            GetGalleryResult = GetGalleryResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identifier = javaType.identifier().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryIdentifierResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sharingProfile = javaType.sharingProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SharingProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sharingStatus = javaType.sharingStatus().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SharingStatusResponse.Companion.toKotlin(args0)
            }),
            softDeletePolicy = javaType.softDeletePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SoftDeletePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
