@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a Virtual Machine.
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the virtual machine.
 * @property applicationProfile Specifies the gallery applications that should be made available to the VM/VMSS.
 * @property availabilitySet Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
 * @property billingProfile Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
 * @property capacityReservation Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property evictionPolicy Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
 * @property extendedLocation The extended location of the Virtual Machine.
 * @property extensionsTimeBudget Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
 * @property hardwareProfile Specifies the hardware settings for the virtual machine.
 * @property host Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
 * @property hostGroup Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
 * @property id Resource Id
 * @property identity The identity of the virtual machine, if configured.
 * @property instanceView The virtual machine instance view.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property location Resource location
 * @property name Resource name
 * @property networkProfile Specifies the network interfaces of the virtual machine.
 * @property osProfile Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property platformFaultDomain Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains. This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than 1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
 * @property priority Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
 * @property resources The virtual machine child extension resources.
 * @property scheduledEventsProfile Specifies Scheduled Event related configurations.
 * @property securityProfile Specifies the Security related profile settings for the virtual machine.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property tags Resource tags
 * @property timeCreated Specifies the time at which the Virtual Machine resource was created. Minimum api-version: 2021-11-01.
 * @property type Resource type
 * @property userData UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
 * @property virtualMachineScaleSet Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
 * @property vmId Specifies the VM unique ID which is a 128-bits identifier that is encoded and stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
 * @property zones The virtual machine zones.
 */
public data class GetVirtualMachineResult(
    public val additionalCapabilities: AdditionalCapabilitiesResponse? = null,
    public val applicationProfile: ApplicationProfileResponse? = null,
    public val availabilitySet: SubResourceResponse? = null,
    public val billingProfile: BillingProfileResponse? = null,
    public val capacityReservation: CapacityReservationProfileResponse? = null,
    public val diagnosticsProfile: DiagnosticsProfileResponse? = null,
    public val evictionPolicy: String? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val extensionsTimeBudget: String? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val host: SubResourceResponse? = null,
    public val hostGroup: SubResourceResponse? = null,
    public val id: String,
    public val identity: VirtualMachineIdentityResponse? = null,
    public val instanceView: VirtualMachineInstanceViewResponse,
    public val licenseType: String? = null,
    public val location: String,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OSProfileResponse? = null,
    public val plan: PlanResponse? = null,
    public val platformFaultDomain: Int? = null,
    public val priority: String? = null,
    public val provisioningState: String,
    public val proximityPlacementGroup: SubResourceResponse? = null,
    public val resources: List<VirtualMachineExtensionResponse>,
    public val scheduledEventsProfile: ScheduledEventsProfileResponse? = null,
    public val securityProfile: SecurityProfileResponse? = null,
    public val storageProfile: StorageProfileResponse? = null,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val type: String,
    public val userData: String? = null,
    public val virtualMachineScaleSet: SubResourceResponse? = null,
    public val vmId: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetVirtualMachineResult):
            GetVirtualMachineResult = GetVirtualMachineResult(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applicationProfile = javaType.applicationProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApplicationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilitySet = javaType.availabilitySet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            billingProfile = javaType.billingProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.BillingProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            capacityReservation = javaType.capacityReservation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diagnosticsProfile = javaType.diagnosticsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            evictionPolicy = javaType.evictionPolicy().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extensionsTimeBudget = javaType.extensionsTimeBudget().map({ args0 -> args0 }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            host = javaType.host().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostGroup = javaType.hostGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineInstanceViewResponse.Companion.toKotlin(args0)
            }),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            platformFaultDomain = javaType.platformFaultDomain().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            proximityPlacementGroup = javaType.proximityPlacementGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            scheduledEventsProfile = javaType.scheduledEventsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ScheduledEventsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            type = javaType.type(),
            userData = javaType.userData().map({ args0 -> args0 }).orElse(null),
            virtualMachineScaleSet = javaType.virtualMachineScaleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmId = javaType.vmId(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
