@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies settings related to VM Guest Patching on Linux.
 * @property assessmentMode Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 * @property automaticByPlatformSettings Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
 * @property patchMode Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
 */
public data class LinuxPatchSettingsResponse(
    public val assessmentMode: String? = null,
    public val automaticByPlatformSettings: LinuxVMGuestPatchAutomaticByPlatformSettingsResponse? =
        null,
    public val patchMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LinuxPatchSettingsResponse):
            LinuxPatchSettingsResponse = LinuxPatchSettingsResponse(
            assessmentMode = javaType.assessmentMode().map({ args0 -> args0 }).orElse(null),
            automaticByPlatformSettings = javaType.automaticByPlatformSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LinuxVMGuestPatchAutomaticByPlatformSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            patchMode = javaType.patchMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
