@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the load balancer configuration.
 * @property id Resource Id
 * @property name The name of the Load balancer
 * @property properties Properties of the load balancer configuration.
 */
public data class LoadBalancerConfigurationResponse(
    public val id: String? = null,
    public val name: String,
    public val properties: LoadBalancerConfigurationPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LoadBalancerConfigurationResponse):
            LoadBalancerConfigurationResponse = LoadBalancerConfigurationResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.LoadBalancerConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
