@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes a network interface reference.
 * @property deleteOption Specify what happens to the network interface when the VM is deleted
 * @property id Resource Id
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 */
public data class NetworkInterfaceReferenceResponse(
    public val deleteOption: String? = null,
    public val id: String? = null,
    public val primary: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.NetworkInterfaceReferenceResponse):
            NetworkInterfaceReferenceResponse = NetworkInterfaceReferenceResponse(
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
        )
    }
}
