@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the network interfaces or the networking configuration of the virtual machine.
 * @property networkApiVersion specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
 * @property networkInterfaceConfigurations Specifies the networking configurations that will be used to create the virtual machine networking resources.
 * @property networkInterfaces Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
 */
public data class NetworkProfileResponse(
    public val networkApiVersion: String? = null,
    public val networkInterfaceConfigurations:
    List<VirtualMachineNetworkInterfaceConfigurationResponse>? = null,
    public val networkInterfaces: List<NetworkInterfaceReferenceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.NetworkProfileResponse):
            NetworkProfileResponse = NetworkProfileResponse(
            networkApiVersion = javaType.networkApiVersion().map({ args0 -> args0 }).orElse(null),
            networkInterfaceConfigurations = javaType.networkInterfaceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineNetworkInterfaceConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.NetworkInterfaceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
