@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress

/**
 * The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
 * @property memory Describes the resource range.
 * @property vCPUs Describes the resource range.
 */
public data class RecommendedMachineConfigurationResponse(
    public val memory: ResourceRangeResponse? = null,
    public val vCPUs: ResourceRangeResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RecommendedMachineConfigurationResponse):
            RecommendedMachineConfigurationResponse = RecommendedMachineConfigurationResponse(
            memory = javaType.memory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ResourceRangeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vCPUs = javaType.vCPUs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ResourceRangeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
