@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * @property id Resource Id
 */
public data class SourceVaultResponse(
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SourceVaultResponse):
            SourceVaultResponse = SourceVaultResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
