@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enable Specifies whether the Terminate Scheduled event is enabled or disabled.
 * @property notBeforeTimeout Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
 */
public data class TerminateNotificationProfileResponse(
    public val enable: Boolean? = null,
    public val notBeforeTimeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.TerminateNotificationProfileResponse):
            TerminateNotificationProfileResponse = TerminateNotificationProfileResponse(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            notBeforeTimeout = javaType.notBeforeTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
