@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an upgrade policy - automatic, manual, or rolling.
 * @property automaticOSUpgradePolicy Configuration parameters used for performing automatic OS Upgrade.
 * @property mode Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
 * @property rollingUpgradePolicy The configuration parameters used while performing a rolling upgrade.
 */
public data class UpgradePolicyResponse(
    public val automaticOSUpgradePolicy: AutomaticOSUpgradePolicyResponse? = null,
    public val mode: String? = null,
    public val rollingUpgradePolicy: RollingUpgradePolicyResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.UpgradePolicyResponse):
            UpgradePolicyResponse = UpgradePolicyResponse(
            automaticOSUpgradePolicy = javaType.automaticOSUpgradePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AutomaticOSUpgradePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            rollingUpgradePolicy = javaType.rollingUpgradePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RollingUpgradePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
