@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The source image from which the Image Version is going to be created.
 * @property defaultConfigurationLink Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
 * @property mediaLink Required. The mediaLink of the artifact, must be a readable storage page blob.
 */
public data class UserArtifactSourceResponse(
    public val defaultConfigurationLink: String? = null,
    public val mediaLink: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.UserArtifactSourceResponse):
            UserArtifactSourceResponse = UserArtifactSourceResponse(
            defaultConfigurationLink = javaType.defaultConfigurationLink().map({ args0 -> args0 }).orElse(null),
            mediaLink = javaType.mediaLink(),
        )
    }
}
