@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property domainNameLabel The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(
    public val domainNameLabel: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse):
            VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse =
            VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(
                domainNameLabel = javaType.domainNameLabel(),
            )
    }
}
