@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The protection policy of a virtual machine scale set VM.
 * @property protectFromScaleIn Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
 * @property protectFromScaleSetActions Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
 */
public data class VirtualMachineScaleSetVMProtectionPolicyResponse(
    public val protectFromScaleIn: Boolean? = null,
    public val protectFromScaleSetActions: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetVMProtectionPolicyResponse):
            VirtualMachineScaleSetVMProtectionPolicyResponse =
            VirtualMachineScaleSetVMProtectionPolicyResponse(
                protectFromScaleIn = javaType.protectFromScaleIn().map({ args0 -> args0 }).orElse(null),
                protectFromScaleSetActions = javaType.protectFromScaleSetActions().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
