@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin

import com.pulumi.azurenative.confidentialledger.ConfidentialledgerFunctions.getLedgerPlain
import com.pulumi.azurenative.confidentialledger.ConfidentialledgerFunctions.getManagedCCFPlain
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.GetLedgerPlainArgs
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.GetLedgerPlainArgsBuilder
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.GetManagedCCFPlainArgs
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.GetManagedCCFPlainArgsBuilder
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.GetLedgerResult
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.GetManagedCCFResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.GetLedgerResult.Companion.toKotlin as getLedgerResultToKotlin
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.GetManagedCCFResult.Companion.toKotlin as getManagedCCFResultToKotlin

public object ConfidentialledgerFunctions {
    /**
     * Retrieves the properties of a Confidential Ledger.
     * Azure REST API version: 2022-05-13.
     * Other available API versions: 2023-01-26-preview, 2023-06-28-preview.
     * @param argument null
     * @return Confidential Ledger. Contains the properties of Confidential Ledger Resource.
     */
    public suspend fun getLedger(argument: GetLedgerPlainArgs): GetLedgerResult =
        getLedgerResultToKotlin(getLedgerPlain(argument.toJava()).await())

    /**
     * @see [getLedger].
     * @param ledgerName Name of the Confidential Ledger
     * @param resourceGroupName The name of the resource group.
     * @return Confidential Ledger. Contains the properties of Confidential Ledger Resource.
     */
    public suspend fun getLedger(ledgerName: String, resourceGroupName: String): GetLedgerResult {
        val argument = GetLedgerPlainArgs(
            ledgerName = ledgerName,
            resourceGroupName = resourceGroupName,
        )
        return getLedgerResultToKotlin(getLedgerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLedger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confidentialledger&#46;kotlin&#46;inputs&#46;GetLedgerPlainArgs].
     * @return Confidential Ledger. Contains the properties of Confidential Ledger Resource.
     */
    public suspend fun getLedger(argument: suspend GetLedgerPlainArgsBuilder.() -> Unit):
        GetLedgerResult {
        val builder = GetLedgerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLedgerResultToKotlin(getLedgerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of a Managed CCF app.
     * Azure REST API version: 2023-01-26-preview.
     * Other available API versions: 2023-06-28-preview.
     * @param argument null
     * @return Managed CCF. Contains the properties of Managed CCF Resource.
     */
    public suspend fun getManagedCCF(argument: GetManagedCCFPlainArgs): GetManagedCCFResult =
        getManagedCCFResultToKotlin(getManagedCCFPlain(argument.toJava()).await())

    /**
     * @see [getManagedCCF].
     * @param appName Name of the Managed CCF
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Managed CCF. Contains the properties of Managed CCF Resource.
     */
    public suspend fun getManagedCCF(appName: String, resourceGroupName: String):
        GetManagedCCFResult {
        val argument = GetManagedCCFPlainArgs(
            appName = appName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedCCFResultToKotlin(getManagedCCFPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedCCF].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confidentialledger&#46;kotlin&#46;inputs&#46;GetManagedCCFPlainArgs].
     * @return Managed CCF. Contains the properties of Managed CCF Resource.
     */
    public suspend fun getManagedCCF(argument: suspend GetManagedCCFPlainArgsBuilder.() -> Unit):
        GetManagedCCFResult {
        val builder = GetManagedCCFPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedCCFResultToKotlin(getManagedCCFPlain(builtArgument.toJava()).await())
    }
}
