@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.CertBasedSecurityPrincipalArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.enums.LedgerRoleName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cert based security principal with Ledger RoleName
 * @property cert Public key of the user cert (.pem or .cer)
 * @property ledgerRoleName LedgerRole associated with the Security Principal of Ledger
 */
public data class CertBasedSecurityPrincipalArgs(
    public val cert: Output<String>? = null,
    public val ledgerRoleName: Output<Either<String, LedgerRoleName>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.CertBasedSecurityPrincipalArgs> {
    override fun toJava():
        com.pulumi.azurenative.confidentialledger.inputs.CertBasedSecurityPrincipalArgs =
        com.pulumi.azurenative.confidentialledger.inputs.CertBasedSecurityPrincipalArgs.builder()
            .cert(cert?.applyValue({ args0 -> args0 }))
            .ledgerRoleName(
                ledgerRoleName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CertBasedSecurityPrincipalArgs].
 */
@PulumiTagMarker
public class CertBasedSecurityPrincipalArgsBuilder internal constructor() {
    private var cert: Output<String>? = null

    private var ledgerRoleName: Output<Either<String, LedgerRoleName>>? = null

    /**
     * @param value Public key of the user cert (.pem or .cer)
     */
    @JvmName("coqoqrpfqdjvxfvk")
    public suspend fun cert(`value`: Output<String>) {
        this.cert = value
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("xtgiwdtlhrecwgsn")
    public suspend fun ledgerRoleName(`value`: Output<Either<String, LedgerRoleName>>) {
        this.ledgerRoleName = value
    }

    /**
     * @param value Public key of the user cert (.pem or .cer)
     */
    @JvmName("hlumrwghxlccahoh")
    public suspend fun cert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cert = mapped
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("ervyxuvfngshqofe")
    public suspend fun ledgerRoleName(`value`: Either<String, LedgerRoleName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("cjmnoggjcoaxfxqq")
    public fun ledgerRoleName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LedgerRoleName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    /**
     * @param value LedgerRole associated with the Security Principal of Ledger
     */
    @JvmName("xwvjmcrulsenovco")
    public fun ledgerRoleName(`value`: LedgerRoleName) {
        val toBeMapped = Either.ofRight<String, LedgerRoleName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerRoleName = mapped
    }

    internal fun build(): CertBasedSecurityPrincipalArgs = CertBasedSecurityPrincipalArgs(
        cert = cert,
        ledgerRoleName = ledgerRoleName,
    )
}
