@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.ManagedCCFPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Additional Managed CCF properties.
 * @property deploymentType Deployment Type of Managed CCF
 * @property memberIdentityCertificates List of member identity certificates for  Managed CCF
 * @property nodeCount Number of CCF nodes in the Managed CCF.
 */
public data class ManagedCCFPropertiesArgs(
    public val deploymentType: Output<DeploymentTypeArgs>? = null,
    public val memberIdentityCertificates: Output<List<MemberIdentityCertificateArgs>>? = null,
    public val nodeCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.ManagedCCFPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.ManagedCCFPropertiesArgs =
        com.pulumi.azurenative.confidentialledger.inputs.ManagedCCFPropertiesArgs.builder()
            .deploymentType(deploymentType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memberIdentityCertificates(
                memberIdentityCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedCCFPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedCCFPropertiesArgsBuilder internal constructor() {
    private var deploymentType: Output<DeploymentTypeArgs>? = null

    private var memberIdentityCertificates: Output<List<MemberIdentityCertificateArgs>>? = null

    private var nodeCount: Output<Int>? = null

    /**
     * @param value Deployment Type of Managed CCF
     */
    @JvmName("dckihrqynrlpkwyx")
    public suspend fun deploymentType(`value`: Output<DeploymentTypeArgs>) {
        this.deploymentType = value
    }

    /**
     * @param value List of member identity certificates for  Managed CCF
     */
    @JvmName("kdcflendxrstrehl")
    public suspend
    fun memberIdentityCertificates(`value`: Output<List<MemberIdentityCertificateArgs>>) {
        this.memberIdentityCertificates = value
    }

    @JvmName("jprtstdyrpcktupr")
    public suspend fun memberIdentityCertificates(
        vararg
        values: Output<MemberIdentityCertificateArgs>,
    ) {
        this.memberIdentityCertificates = Output.all(values.asList())
    }

    /**
     * @param values List of member identity certificates for  Managed CCF
     */
    @JvmName("opanihogvkjlnofk")
    public suspend
    fun memberIdentityCertificates(values: List<Output<MemberIdentityCertificateArgs>>) {
        this.memberIdentityCertificates = Output.all(values)
    }

    /**
     * @param value Number of CCF nodes in the Managed CCF.
     */
    @JvmName("esbblbxnukygronv")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value Deployment Type of Managed CCF
     */
    @JvmName("uqtmighbpcbwmefi")
    public suspend fun deploymentType(`value`: DeploymentTypeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param argument Deployment Type of Managed CCF
     */
    @JvmName("lckrirsltnipubpp")
    public suspend fun deploymentType(argument: suspend DeploymentTypeArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentTypeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentType = mapped
    }

    /**
     * @param value List of member identity certificates for  Managed CCF
     */
    @JvmName("hukrdotxpkyvbcgp")
    public suspend fun memberIdentityCertificates(`value`: List<MemberIdentityCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberIdentityCertificates = mapped
    }

    /**
     * @param argument List of member identity certificates for  Managed CCF
     */
    @JvmName("rdqstqdjdmxvorkc")
    public suspend
    fun memberIdentityCertificates(argument: List<suspend MemberIdentityCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MemberIdentityCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberIdentityCertificates = mapped
    }

    /**
     * @param argument List of member identity certificates for  Managed CCF
     */
    @JvmName("kauderwlvwiiexsi")
    public suspend fun memberIdentityCertificates(
        vararg
        argument: suspend MemberIdentityCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MemberIdentityCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberIdentityCertificates = mapped
    }

    /**
     * @param argument List of member identity certificates for  Managed CCF
     */
    @JvmName("ssnxjakohwpkhmxi")
    public suspend
    fun memberIdentityCertificates(argument: suspend MemberIdentityCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MemberIdentityCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.memberIdentityCertificates = mapped
    }

    /**
     * @param values List of member identity certificates for  Managed CCF
     */
    @JvmName("uofdlphhwtamgxmo")
    public suspend fun memberIdentityCertificates(vararg values: MemberIdentityCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberIdentityCertificates = mapped
    }

    /**
     * @param value Number of CCF nodes in the Managed CCF.
     */
    @JvmName("xbvngtixgjxkdoax")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    internal fun build(): ManagedCCFPropertiesArgs = ManagedCCFPropertiesArgs(
        deploymentType = deploymentType,
        memberIdentityCertificates = memberIdentityCertificates,
        nodeCount = nodeCount,
    )
}
