@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AAD based security principal with associated Ledger RoleName
 * @property ledgerRoleName LedgerRole associated with the Security Principal of Ledger
 * @property principalId UUID/GUID based Principal Id of the Security Principal
 * @property tenantId UUID/GUID based Tenant Id of the Security Principal
 */
public data class AADBasedSecurityPrincipalResponse(
    public val ledgerRoleName: String? = null,
    public val principalId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.AADBasedSecurityPrincipalResponse):
            AADBasedSecurityPrincipalResponse = AADBasedSecurityPrincipalResponse(
            ledgerRoleName = javaType.ledgerRoleName().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
