@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Object representing DeploymentType for Managed CCF.
 * @property appSourceUri Source Uri containing ManagedCCF code
 * @property languageRuntime Unique name for the Managed CCF.
 */
public data class DeploymentTypeResponse(
    public val appSourceUri: String? = null,
    public val languageRuntime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confidentialledger.outputs.DeploymentTypeResponse):
            DeploymentTypeResponse = DeploymentTypeResponse(
            appSourceUri = javaType.appSourceUri().map({ args0 -> args0 }).orElse(null),
            languageRuntime = javaType.languageRuntime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
