@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin

import com.pulumi.azurenative.confluent.OrganizationArgs.builder
import com.pulumi.azurenative.confluent.kotlin.inputs.OfferDetailArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.OfferDetailArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.UserDetailArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.UserDetailArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Organization resource.
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2020-03-01-preview, 2023-08-22.
 * ## Example Usage
 * ### Organization_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var organization = new AzureNative.Confluent.Organization("organization", new()
 *     {
 *         Location = "West US",
 *         OfferDetail = new AzureNative.Confluent.Inputs.OfferDetailArgs
 *         {
 *             Id = "string",
 *             PlanId = "string",
 *             PlanName = "string",
 *             PublisherId = "string",
 *             TermUnit = "string",
 *         },
 *         OrganizationName = "myOrganization",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "Environment", "Dev" },
 *         },
 *         UserDetail = new AzureNative.Confluent.Inputs.UserDetailArgs
 *         {
 *             EmailAddress = "contoso@microsoft.com",
 *             FirstName = "string",
 *             LastName = "string",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/confluent/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := confluent.NewOrganization(ctx, "organization", &confluent.OrganizationArgs{
 * 			Location: pulumi.String("West US"),
 * 			OfferDetail: &confluent.OfferDetailArgs{
 * 				Id:          pulumi.String("string"),
 * 				PlanId:      pulumi.String("string"),
 * 				PlanName:    pulumi.String("string"),
 * 				PublisherId: pulumi.String("string"),
 * 				TermUnit:    pulumi.String("string"),
 * 			},
 * 			OrganizationName:  pulumi.String("myOrganization"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 			UserDetail: &confluent.UserDetailArgs{
 * 				EmailAddress: pulumi.String("contoso@microsoft.com"),
 * 				FirstName:    pulumi.String("string"),
 * 				LastName:     pulumi.String("string"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.confluent.Organization;
 * import com.pulumi.azurenative.confluent.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organization = new Organization("organization", OrganizationArgs.builder()
 *             .location("West US")
 *             .offerDetail(Map.ofEntries(
 *                 Map.entry("id", "string"),
 *                 Map.entry("planId", "string"),
 *                 Map.entry("planName", "string"),
 *                 Map.entry("publisherId", "string"),
 *                 Map.entry("termUnit", "string")
 *             ))
 *             .organizationName("myOrganization")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("Environment", "Dev"))
 *             .userDetail(Map.ofEntries(
 *                 Map.entry("emailAddress", "contoso@microsoft.com"),
 *                 Map.entry("firstName", "string"),
 *                 Map.entry("lastName", "string")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confluent:Organization myOrganization /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}
 * ```
 * @property location Location of Organization resource
 * @property offerDetail Confluent offer detail
 * @property organizationName Organization resource name
 * @property resourceGroupName Resource group name
 * @property tags Organization resource tags
 * @property userDetail Subscriber detail
 */
public data class OrganizationArgs(
    public val location: Output<String>? = null,
    public val offerDetail: Output<OfferDetailArgs>? = null,
    public val organizationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userDetail: Output<UserDetailArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confluent.OrganizationArgs> {
    override fun toJava(): com.pulumi.azurenative.confluent.OrganizationArgs =
        com.pulumi.azurenative.confluent.OrganizationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .offerDetail(offerDetail?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .organizationName(organizationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userDetail(userDetail?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrganizationArgs].
 */
@PulumiTagMarker
public class OrganizationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var offerDetail: Output<OfferDetailArgs>? = null

    private var organizationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userDetail: Output<UserDetailArgs>? = null

    /**
     * @param value Location of Organization resource
     */
    @JvmName("mhcbnkvvqxqlkovq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Confluent offer detail
     */
    @JvmName("aniuiotgyutgdbkj")
    public suspend fun offerDetail(`value`: Output<OfferDetailArgs>) {
        this.offerDetail = value
    }

    /**
     * @param value Organization resource name
     */
    @JvmName("dknhhrepijfgyhwq")
    public suspend fun organizationName(`value`: Output<String>) {
        this.organizationName = value
    }

    /**
     * @param value Resource group name
     */
    @JvmName("sxfuiuemclbponhd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Organization resource tags
     */
    @JvmName("owalpnyxnqwkvfma")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Subscriber detail
     */
    @JvmName("eaitylvynhpcbwmo")
    public suspend fun userDetail(`value`: Output<UserDetailArgs>) {
        this.userDetail = value
    }

    /**
     * @param value Location of Organization resource
     */
    @JvmName("epfypphfnawuotao")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Confluent offer detail
     */
    @JvmName("ktcssqirjsxtywrk")
    public suspend fun offerDetail(`value`: OfferDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerDetail = mapped
    }

    /**
     * @param argument Confluent offer detail
     */
    @JvmName("gmiejgleohokellu")
    public suspend fun offerDetail(argument: suspend OfferDetailArgsBuilder.() -> Unit) {
        val toBeMapped = OfferDetailArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offerDetail = mapped
    }

    /**
     * @param value Organization resource name
     */
    @JvmName("mlyqtbhmtuukgknd")
    public suspend fun organizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("ngeihvcmcdfypkvg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Organization resource tags
     */
    @JvmName("bhljvuibpypfiogd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Organization resource tags
     */
    @JvmName("idngoufjhbkluewc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Subscriber detail
     */
    @JvmName("lgnikjseeyccurlk")
    public suspend fun userDetail(`value`: UserDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDetail = mapped
    }

    /**
     * @param argument Subscriber detail
     */
    @JvmName("ekkjawgrmawecsuw")
    public suspend fun userDetail(argument: suspend UserDetailArgsBuilder.() -> Unit) {
        val toBeMapped = UserDetailArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userDetail = mapped
    }

    internal fun build(): OrganizationArgs = OrganizationArgs(
        location = location,
        offerDetail = offerDetail,
        organizationName = organizationName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userDetail = userDetail,
    )
}
