@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.inputs

import com.pulumi.azurenative.confluent.inputs.GetOrganizationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property organizationName Organization resource name
 * @property resourceGroupName Resource group name
 */
public data class GetOrganizationPlainArgs(
    public val organizationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.confluent.inputs.GetOrganizationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.confluent.inputs.GetOrganizationPlainArgs =
        com.pulumi.azurenative.confluent.inputs.GetOrganizationPlainArgs.builder()
            .organizationName(organizationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationPlainArgsBuilder internal constructor() {
    private var organizationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Organization resource name
     */
    @JvmName("araxnxybisecxbjt")
    public suspend fun organizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.organizationName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("htrocthoafdkqaqc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOrganizationPlainArgs = GetOrganizationPlainArgs(
        organizationName = organizationName ?: throw PulumiNullFieldException("organizationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
