@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Spec of the cluster record
 * @property apiEndpoint The Kafka API cluster endpoint
 * @property availability The availability zone configuration of the cluster
 * @property byok Specification of the cluster
 * @property cloud The cloud service provider
 * @property config Specification of the cluster
 * @property displayName The name of the cluster
 * @property environment Specification of the cluster
 * @property httpEndpoint The cluster HTTP request URL.
 * @property kafkaBootstrapEndpoint The bootstrap endpoint used by Kafka clients to connect to the cluster
 * @property network Specification of the cluster
 * @property region The cloud service provider region
 * @property zone type of zone availability
 */
public data class ClusterSpecEntityResponse(
    public val apiEndpoint: String? = null,
    public val availability: String? = null,
    public val byok: ClusterByokEntityResponse? = null,
    public val cloud: String? = null,
    public val config: ClusterConfigEntityResponse? = null,
    public val displayName: String? = null,
    public val environment: ClusterEnvironmentEntityResponse? = null,
    public val httpEndpoint: String? = null,
    public val kafkaBootstrapEndpoint: String? = null,
    public val network: ClusterNetworkEntityResponse? = null,
    public val region: String? = null,
    public val zone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ClusterSpecEntityResponse):
            ClusterSpecEntityResponse = ClusterSpecEntityResponse(
            apiEndpoint = javaType.apiEndpoint().map({ args0 -> args0 }).orElse(null),
            availability = javaType.availability().map({ args0 -> args0 }).orElse(null),
            byok = javaType.byok().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ClusterByokEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cloud = javaType.cloud().map({ args0 -> args0 }).orElse(null),
            config = javaType.config().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ClusterConfigEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            environment = javaType.environment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ClusterEnvironmentEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpEndpoint = javaType.httpEndpoint().map({ args0 -> args0 }).orElse(null),
            kafkaBootstrapEndpoint = javaType.kafkaBootstrapEndpoint().map({ args0 -> args0 }).orElse(null),
            network = javaType.network().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ClusterNetworkEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            zone = javaType.zone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
