@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record of the invitation
 * @property acceptedAt Accepted date time of the invitation
 * @property authType Auth type of the user
 * @property email Email of the user
 * @property expiresAt Expiration date time of the invitation
 * @property id Id of the invitation
 * @property kind Type of account
 * @property metadata Metadata of the record
 * @property status Status of the invitation
 */
public data class InvitationRecordResponse(
    public val acceptedAt: String? = null,
    public val authType: String? = null,
    public val email: String? = null,
    public val expiresAt: String? = null,
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: MetadataEntityResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.InvitationRecordResponse):
            InvitationRecordResponse = InvitationRecordResponse(
            acceptedAt = javaType.acceptedAt().map({ args0 -> args0 }).orElse(null),
            authType = javaType.authType().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            expiresAt = javaType.expiresAt().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.MetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
