@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.GuestAgentArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.ProvisioningAction
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestCredentialArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestCredentialArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HttpProxyConfigurationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HttpProxyConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestAgent = new AzureNative.ConnectedVMwarevSphere.GuestAgent("guestAgent", new()
 *     {
 *         Credentials = new AzureNative.ConnectedVMwarevSphere.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         HttpProxyConfig = new AzureNative.ConnectedVMwarevSphere.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         Name = "default",
 *         ProvisioningAction = "install",
 *         ResourceGroupName = "testrg",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewGuestAgent(ctx, "guestAgent", &connectedvmwarevsphere.GuestAgentArgs{
 * 			Credentials: &connectedvmwarevsphere.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			HttpProxyConfig: &connectedvmwarevsphere.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			Name:               pulumi.String("default"),
 * 			ProvisioningAction: pulumi.String("install"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.GuestAgent;
 * import com.pulumi.azurenative.connectedvmwarevsphere.GuestAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestAgent = new GuestAgent("guestAgent", GuestAgentArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("username", "tempuser")
 *             ))
 *             .httpProxyConfig(Map.of("httpsProxy", "http://192.1.2.3:8080"))
 *             .name("default")
 *             .provisioningAction("install")
 *             .resourceGroupName("testrg")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:GuestAgent default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachines/{virtualMachineName}/guestAgents/{name}
 * ```
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property name Name of the guestAgents.
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineName Name of the vm.
 */
public data class GuestAgentArgs(
    public val credentials: Output<GuestCredentialArgs>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val provisioningAction: Output<Either<String, ProvisioningAction>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.GuestAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.GuestAgentArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.GuestAgentArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .provisioningAction(
                provisioningAction?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestAgentArgs].
 */
@PulumiTagMarker
public class GuestAgentArgsBuilder internal constructor() {
    private var credentials: Output<GuestCredentialArgs>? = null

    private var httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var provisioningAction: Output<Either<String, ProvisioningAction>>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("acwisgyqsgalsvid")
    public suspend fun credentials(`value`: Output<GuestCredentialArgs>) {
        this.credentials = value
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("qnlovfithjrtbhac")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigurationArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value Name of the guestAgents.
     */
    @JvmName("oxjfrrlohopvqdbd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("vbuonyfsjkfrrojq")
    public suspend fun provisioningAction(`value`: Output<Either<String, ProvisioningAction>>) {
        this.provisioningAction = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("vsdxotppsnevhjgo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("hpqhjjqbrgbvfjmq")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("govotqwrjicrguye")
    public suspend fun credentials(`value`: GuestCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Username / Password Credentials to provision guest agent.
     */
    @JvmName("idlwngbxgurvyjag")
    public suspend fun credentials(argument: suspend GuestCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = GuestCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("xamiqnakrlqfurqh")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HTTP Proxy configuration for the VM.
     */
    @JvmName("cjadfqbfmvbwqxbt")
    public suspend
    fun httpProxyConfig(argument: suspend HttpProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value Name of the guestAgents.
     */
    @JvmName("dvcsrybjhhafqjjp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("oaqdivkyuuvobist")
    public suspend fun provisioningAction(`value`: Either<String, ProvisioningAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("pgjpuwbjsfjnoife")
    public fun provisioningAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("uenfxisxetolvdai")
    public fun provisioningAction(`value`: ProvisioningAction) {
        val toBeMapped = Either.ofRight<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("qbtsfkxebaqolyal")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("kinyhhwxubyfudfv")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): GuestAgentArgs = GuestAgentArgs(
        credentials = credentials,
        httpProxyConfig = httpProxyConfig,
        name = name,
        provisioningAction = provisioningAction,
        resourceGroupName = resourceGroupName,
        virtualMachineName = virtualMachineName,
    )
}
